/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.sound;

import io.github.foundationgames.automobility.automobile.HornSoundDefinition;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.sound.AdvancedTickableSoundInstance;
import io.github.foundationgames.automobility.sound.AutomobileSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import org.lwjgl.openal.AL10;

public abstract class SlicedLoopingAutomobileSoundInstance
extends AutomobileSoundInstance
implements AdvancedTickableSoundInstance {
    public static final float TICK_LENGTH = 0.05f;
    public final float loopStart;
    public final float loopEnd;
    protected boolean continueSlicedLoop = false;

    public SlicedLoopingAutomobileSoundInstance(SoundEvent sound, Minecraft client, AutomobileEntity automobile, float loopStart, float loopEnd) {
        super(sound, client, automobile);
        this.loopStart = loopStart;
        this.loopEnd = loopEnd;
        this.looping = false;
    }

    @Override
    public void updateALState(int source) {
        int buffer = AL10.alGetSourcei((int)source, (int)4105);
        int size = AL10.alGetBufferi((int)buffer, (int)8196);
        int channels = AL10.alGetBufferi((int)buffer, (int)8195);
        int bits = AL10.alGetBufferi((int)buffer, (int)8194);
        int freq = AL10.alGetBufferi((int)buffer, (int)8193);
        float duration = (float)(size * 8) / (float)(channels * bits * freq);
        float lStart = this.loopStart;
        float lEnd = this.loopEnd;
        boolean mayLoop = lStart > 0.0f && lEnd > 0.0f;
        lStart = Math.max(0.0f, lStart);
        lEnd = Math.min(duration, lEnd);
        if (mayLoop) {
            float os = AL10.alGetSourcef((int)source, (int)4132);
            if (this.continueSlicedLoop) {
                if (os > lEnd - 0.05f) {
                    AL10.alSourcef((int)source, (int)4132, (float)lStart);
                }
            } else if (os < lStart) {
                AL10.alSourcef((int)source, (int)4132, (float)Math.clamp(duration - lStart, lEnd, duration));
            } else if (os < lEnd) {
                AL10.alSourcef((int)source, (int)4132, (float)lEnd);
            }
        }
    }

    public static class HornSound
    extends SlicedLoopingAutomobileSoundInstance {
        private final float hornPitch;

        public HornSound(Minecraft client, AutomobileEntity automobile, HornSoundDefinition hornSound, float pitch) {
            super(hornSound.sound().get(), client, automobile, hornSound.loopStart(), hornSound.loopEnd());
            this.hornPitch = pitch;
            this.continueSlicedLoop = true;
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return !this.isStopped();
        }

        @Override
        public void tick() {
            super.tick();
            if (!this.automobile.honking()) {
                this.continueSlicedLoop = false;
            }
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return this.hornPitch;
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return 2.0f;
        }
    }
}

